
:setvar DatabaseName "RegistryQA"
:setvar MajorReleaseNumber "1"
:setvar MinorReleaseNumber "0"
:setvar PointReleaseNumber "24"
:setvar DeployVersion "20150223.1"
GO

:on error exit
GO
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END
GO
USE [$(DatabaseName)];

GO
PRINT 'Rollback of AHOBPR database changes Started';
PRINT ' 
------------------------------------------------------------------------------------------------
Rollback.Registry.AHOBPR.sql

Version Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

Build $(DeployVersion)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Rollback of AHOBPR database changes Started ' + CAST(GETDATE() as varchar(20)) + '.';

DECLARE @FullObjectName varchar(200);

PRINT 'Drop Proceedures...';
SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(objects.name)) +']'
                           FROM sys.objects
                           JOIN  sys.schemas
                             ON objects.schema_id = schemas.schema_id
                          WHERE objects.type in (N'P', N'PC')
                            AND  schemas.name = 'AHOBPR'            
                       ORDER BY schemas.name, objects.name
                       );
                 
WHILE @FullObjectName IS NOT NULL
BEGIN
  PRINT 'Drop PROCEDURE ' + @FullObjectName;
  EXECUTE('DROP PROCEDURE ' + @FullObjectName );

  SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(objects.name)) +']'
                             FROM sys.objects
                             JOIN  sys.schemas
                               ON objects.schema_id = schemas.schema_id
                            WHERE objects.type in (N'P', N'PC')
                              AND  schemas.name = 'AHOBPR' 
                         ORDER BY schemas.name, objects.name
                           );
 END;
 
PRINT 'Drop Views...';
-- VIEWS   
SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(views.name)) +']'
                         FROM sys.views
                         JOIN  sys.schemas
                           ON views.schema_id = schemas.schema_id
                        WHERE views.type in (N'V', N'PC')
                          AND  schemas.name = 'AHOBPR' 
                     ORDER BY schemas.name, views.name   
                        );
                 
WHILE @FullObjectName IS NOT NULL
BEGIN
  PRINT 'Drop VIEW ' + @FullObjectName;
  EXECUTE('DROP VIEW ' + @FullObjectName );

  SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(views.name)) +']'
                           FROM sys.views
                           JOIN  sys.schemas
                             ON views.schema_id = schemas.schema_id
                          WHERE views.type in (N'V', N'PC')
                            AND  schemas.name = 'AHOBPR' 
                       ORDER BY schemas.name, views.name   
                          );
END;

PRINT 'Drop Functions...';

SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(objects.name)) +']'
                           FROM sys.objects
                           JOIN  sys.schemas
                             ON objects.schema_id = schemas.schema_id
                          WHERE objects.type in ('FN', N'IF', N'TF', N'FS', N'FT')
                            AND  schemas.name = 'AHOBPR' 
                       ORDER BY schemas.name, objects.name
                            );
                 
WHILE @FullObjectName IS NOT NULL
BEGIN
  PRINT 'Drop Function ' + @FullObjectName;
  EXECUTE('DROP FUNCTION ' + @FullObjectName );

  SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(objects.name)) +']'
                             FROM sys.objects
                             JOIN  sys.schemas
                               ON objects.schema_id = schemas.schema_id
                            WHERE objects.type in ('FN', N'IF', N'TF', N'FS', N'FT')
                              AND  schemas.name = 'AHOBPR' 
                         ORDER BY schemas.name, objects.name
                           );
END;

PRINT 'Drop Constraints...';    

SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(parent.name)) +']'
                                 + ' DROP CONSTRAINT [' + LTRIM(RTRIM(objects.name)) +']'
                             FROM sys.objects
                             JOIN sys.schemas
                               ON objects.schema_id = schemas.schema_id
                             JOIN sys.objects parent
                               on Objects.parent_object_id = parent.object_id
                            WHERE schemas.name = 'AHOBPR'
                            AND objects.type = N'F' 
                         ORDER BY schemas.name, objects.name
                         );
                         
WHILE @FullObjectName IS NOT NULL
BEGIN
  PRINT 'Alter Table ' + @FullObjectName;
  EXECUTE('ALTER TABLE ' + @FullObjectName );

  SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(parent.name)) +']'
                                 + ' DROP CONSTRAINT [' + LTRIM(RTRIM(objects.name)) +']'
                             FROM sys.objects
                             JOIN sys.schemas
                               ON objects.schema_id = schemas.schema_id
                             JOIN sys.objects parent
                               on Objects.parent_object_id = parent.object_id
                            WHERE schemas.name = 'AHOBPR'
                            AND objects.type = N'F' 
                         ORDER BY schemas.name, objects.name
                         );
END;
                         
PRINT 'Drop Tables...';

SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(objects.name)) +']'
                           FROM sys.objects
                           JOIN  sys.schemas
                             ON objects.[schema_id] = schemas.[schema_id]
                          WHERE schemas.name = 'AHOBPR'
                            AND objects.type in ('U')
                       ORDER BY schemas.name, objects.name
                            );
                 
WHILE @FullObjectName IS NOT NULL
BEGIN
  PRINT 'Drop Table ' + @FullObjectName;
  EXECUTE('DROP TABLE ' + @FullObjectName );

  SET @FullObjectName = (SELECT TOP 1 '[' + LTRIM(RTRIM(schemas.name)) + '].[' + LTRIM(RTRIM(objects.name)) +']'
                           FROM sys.objects
                           JOIN  sys.schemas
                             ON objects.[schema_id] = schemas.[schema_id]
                          WHERE schemas.name = 'AHOBPR'
                            AND objects.type in ('U')
                       ORDER BY schemas.name, objects.name
                            );
END;                             
        
  
PRINT 'Drop Types...';

IF  EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'JSON_Hierarchy' AND ss.name = N'AHOBPR')
DROP TYPE [AHOBPR].[JSON_Hierarchy];


IF  EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'JSONHierarchy' AND ss.name = N'AHOBPR')
DROP TYPE [AHOBPR].[JSONHierarchy];

  PRINT 'Drop Schema AHOBPR...';
IF  EXISTS (SELECT * FROM sys.schemas WHERE name = N'AHOBPR')
DROP SCHEMA [AHOBPR];

  PRINT 'Delete AHOBPR ROLE_PERMISSION records...';
  DELETE FROM [dbo].[ROLE_PERMISSIONS]
         WHERE [STD_ROLE_ID] IN 
               (SELECT ID FROM [dbo].[STD_ROLE] WHERE [CODE] LIKE 'AHOBPR_%');

  PRINT 'Delete AHOBPR USER_ROLES records...';
  DELETE FROM [dbo].[USER_ROLES]
        WHERE [STD_ROLE_ID] IN 
              (SELECT ID FROM [dbo].[STD_ROLE] WHERE [CODE] LIKE 'AHOBPR_%'); 
 
  PRINT 'Delete AHOBPR STD_ROLE records...';
  DELETE FROM [dbo].[STD_ROLE]
        WHERE [CODE] LIKE 'AHOBPR_%';
    
  PRINT 'Delete AHOBPR STD_APPPAGE records...';
DELETE FROM [dbo].[STD_APPPAGE]
      WHERE [CODE] LIKE 'AHOBPR %';

  PRINT 'Delete AHOBPR USER_REGISTRIES records...';
DELETE FROM [dbo].[USER_REGISTRIES]
      WHERE STD_REGISTRY_ID = (SELECT ID FROM [dbo].[STD_REGISTRY] WHERE [CODE] = 'AHOBPR');
  
   PRINT 'Delete AHOBPR STD_GUI_CONTROLS records...';
DELETE FROM [dbo].[STD_GUI_CONTROLS]
      WHERE STD_REGISTRY_ID = (SELECT ID FROM [dbo].[STD_REGISTRY] WHERE [CODE] = 'AHOBPR'); 
                                     
PRINT 'Delete AHOBPR STD_REGISTRY records...';
DELETE FROM [dbo].[STD_REGISTRY]
      WHERE [CODE] = 'AHOBPR'; 

PRINT 'Alter Database remove AHOBPR_V24 FILE...';
IF EXISTS(SELECT * FROM sys.database_files WHERE [NAME] = 'AHOBPR_V24')
ALTER DATABASE [$(DatabaseName)]
      REMOVE FILE AHOBPR_V24; 

PRINT 'Alter Database remove AHOBPR FILE...';
IF EXISTS(SELECT * FROM sys.database_files WHERE [NAME] = 'AHOBPR')
ALTER DATABASE [$(DatabaseName)]
      REMOVE FILE AHOBPR;    

PRINT 'Alter Database remove AHOBPR FILEGROUP...';
IF EXISTS(SELECT * FROM sys.filegroups WHERE [NAME] = 'AHOBPR')
ALTER DATABASE [$(DatabaseName)]
      REMOVE FILEGROUP [AHOBPR];          
  
PRINT 'Remove [dbo] functions added for AHOBPR...';

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AddMaxTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[AddMaxTime];

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CleanDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[CleanDate];

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MixedCase]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[MixedCase];

    
PRINT 'Write to DatabaseChangeLog...';
GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('$(MajorReleaseNumber)'
           ,'$(MinorReleaseNumber)'
           ,'$(PointReleaseNumber)'
           ,0
           ,'Rollback.Registry.AHOBPR.sql'
		       ,'AHOBPR 1.0.24 Deployment Rollback'
           ,'AHOBPR'
           ,GETDATE());
GO
      
       
                                   
PRINT 'AHOBPR Rollback Completed';    
GO                               